/** @file   mp3player.cpp
 * @brief   Implementation of MP3Player class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:40 $
 * @author  Tomi Lamminsaari
 */

#include <almp3.h>
#include "mp3player.h"

namespace eng2d {


//********************************************************************
//                                                                   *
//      Static members and constants                                 *
//                                                                   *
//********************************************************************

bool MP3Player::playing = false;
long MP3Player::bufferSize = 32768;
int MP3Player::vol = 128;
int MP3Player::pan = 128;
MP3File* MP3Player::pMusic = 0;



//********************************************************************
//                                                                   *
//      Constructors, destructor and operators                       *
//                                                                   *
//********************************************************************

/** Constructs new MP3Player
 */
MP3Player::MP3Player()
{
}





/** Destructor
 */
MP3Player::~MP3Player()
{
}




/** Sets the MP3File. We do not start the playback yet.
 */
bool MP3Player::setMP3( MP3File* pMP3 )
{
  pMusic = pMP3;
  if ( pMusic == 0 ) {
    return false;
  }
  
  // If the pointer to MP3-file ain't null, we open it.
  if ( pMusic->open() == 0 ) {
    return true;
  }
  return false;
}



/** Starts the playback of current MP3File.
 */
int MP3Player::play()
{
  if ( pMusic == 0 ) {
    // No mp3 set, no error
    return ALMP3_OK;
  }
  
  
  if ( pMusic->getMP3() == 0 ) {
    // We couldn't open the mp3-file
    return ALMP3_OK;
  }
  
  // Start the playback
  playing = true;
  return almp3_play_mp3( pMusic->getMP3(), bufferSize, vol, pan);
}



/** Stops or pauses the playback
 */
void MP3Player::stop()
{
  playing = false;
  
  if ( pMusic != 0 ) {
    if ( pMusic->getMP3() != 0 ) {
      almp3_stop_mp3( pMusic->getMP3() );
    }
  }
}



/** Polls the mp3-file. This must be done regulary or the playback
 * doesn't work.
 */
int MP3Player::poll()
{
  if ( pMusic == 0 ) return ALMP3_OK;
  if ( pMusic->getMP3() == 0 ) return ALMP3_OK;
  
  return almp3_poll_mp3( pMusic->getMP3() );
}



/** Adjusts the volume
 */
void MP3Player::volume(int v)
{
  vol = v;
  if ( pMusic == 0 ) {
    return;
  }
  if ( pMusic->getMP3() == 0 ) {
    return;
  }
  
  if ( playing ) {
    almp3_adjust_mp3( pMusic->getMP3(), vol, pan, 1000, 0 );
  }
}



//********************************************************************
//                                                                   *
//      Public GET - methods                                         *
//                                                                   *
//********************************************************************

/** Returns the current volume
 */
int MP3Player::volume()
{
  return vol;
}

}
